/*ALIAS>l_data*/

/*ManyStart>820*/
CREATE GENERATOR GEN_HISTORY_GROUP;
SET GENERATOR GEN_HISTORY_GROUP TO 0;
/*ManyStop*/

/*SQLStart>821*/
CREATE TABLE AODOCINFO_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  AODOCINFO_ID INTEGER,
  AODOCINFO_REG INTEGER,
  AODOCINFO_REGID INTEGER,
  AODOCINFO_AODOCID INTEGER
);
/*SQLStop*/

/*ManyStart>822*/
CREATE GENERATOR GEN_HIST_AODOCINFO;
SET GENERATOR GEN_HIST_AODOCINFO TO 0;
/*ManyStop*/

/*SQLStart>823*/
CREATE OR ALTER trigger AODOCINFO_HIST_I_TR for AODOCINFO_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_AODOCINFO,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*SQLStart>824*/
GRANT ALL ON AODOCINFO_HIST TO PUBLIC;
/*SQLStop*/

/*SQLStart>825*/
CREATE TABLE BLANKS_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  B_ID INTEGER,
  B_NAME VARCHAR(200),
  B_COMMENT VARCHAR(200),
  B_TYPE SMALLINT,
  B_DATA BLOB SUB_TYPE 0
);
/*SQLStop*/

/*ManyStart>826*/
CREATE GENERATOR GEN_HIST_BLANKS;
SET GENERATOR GEN_HIST_BLANKS TO 0;
/*ManyStop*/

/*SQLStart>827*/
CREATE OR ALTER trigger BLANKS_HIST_I_TR for BLANKS_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_BLANKS,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*SQLStart>828*/
GRANT ALL ON BLANKS_HIST TO PUBLIC;
/*SQLStop*/

/*SQLStart>829*/
CREATE TABLE BLOBINFO_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  BLOBINFO_REG INTEGER,
  BLOBINFO_REGTYPE INTEGER,
  BLOBINFO_NUM INTEGER,
  BLOBINFO_BLOB BLOB SUB_TYPE 1
);
/*SQLStop*/

/*ManyStart>830*/
CREATE GENERATOR GEN_HIST_BLOBINFO;
SET GENERATOR GEN_HIST_BLOBINFO TO 0;
/*ManyStop*/

/*SQLStart>831*/
CREATE OR ALTER trigger BLOBINFO_HIST_I_TR for BLOBINFO_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_BLOBINFO,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>832*/
GRANT ALL ON BLOBINFO_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>833*/
CREATE TABLE CARDRIVERS_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  CARDRIVER_ID INTEGER,
  CARDRIVER_NUM INTEGER,
  CARDRIVER_PERSON INTEGER,
  CARDRIVER_COMMENT VARCHAR(240),
  CARDRIVER_ACTIVE BOOLEAN  DEFAULT 1,
  CARDRIVER_ERASED BOOLEAN  DEFAULT 0
);
/*SQLStop*/

/*ManyStart>834*/
CREATE GENERATOR GEN_HIST_CARDRIVERS;
SET GENERATOR GEN_HIST_CARDRIVERS TO 0;
/*ManyStop*/

/*SQLStart>835*/
CREATE OR ALTER trigger CARDRIVERS_HIST_I_TR for CARDRIVERS_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_CARDRIVERS,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>836*/
GRANT ALL ON CARDRIVERS_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>837*/
CREATE TABLE CARMARK_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  CARMARK_ID INTEGER,
  CARMARK_TEXT VARCHAR(240),
  CARMARK_NUMKIND INTEGER
);
/*SQLStop*/

/*ManyStart>838*/
CREATE GENERATOR GEN_HIST_CARMARK;
SET GENERATOR GEN_HIST_CARMARK TO 0;
/*ManyStop*/

/*SQLStart>839*/
CREATE OR ALTER trigger CARMARK_HIST_I_TR for CARMARK_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_CARMARK,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>840*/
GRANT ALL ON CARMARK_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>841*/
CREATE TABLE CARMODEL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  CARMODEL_ID INTEGER,
  CARMODEL_CARMARKID INTEGER,
  CARMODEL_TEXT VARCHAR(240),
  CARMODEL_NUMKIND INTEGER
);
/*SQLStop*/

/*ManyStart>842*/
CREATE GENERATOR GEN_HIST_CARMODEL;
SET GENERATOR GEN_HIST_CARMODEL TO 0;
/*ManyStop*/

/*SQLStart>843*/
CREATE OR ALTER trigger CARMODEL_HIST_I_TR for CARMODEL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_CARMODEL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>844*/
GRANT ALL ON CARMODEL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>845*/
CREATE TABLE CARS_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  CAR_ID INTEGER,
  CAR_MARK INTEGER,
  CAR_MODEL INTEGER,
  CAR_CITY INTEGER,
  CAR_OWNER INTEGER,
  CAR_REGNUM VARCHAR(50),
  CAR_YEAR INTEGER,
  CAR_COMMENT VARCHAR(240)
);
/*SQLStop*/

/*ManyStart>846*/
CREATE GENERATOR GEN_HIST_CARS;
SET GENERATOR GEN_HIST_CARS TO 0;
/*ManyStop*/

/*SQLStart>847*/
CREATE OR ALTER trigger CARS_HIST_I_TR for CARS_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_CARS,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>848*/
GRANT ALL ON CARS_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>849*/
CREATE TABLE CATEGORIZE_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  CAT_ID INTEGER,
  CAT_CERT VARCHAR(50),
  CAT_CERTDATESTART DATE,
  CAT_CERTDATESTOP DATE,
  CAT_CERTTERM VARCHAR(50),
  CAT_CERTTERMDATESTART DATE,
  CAT_CERTTERMDATESTOP DATE,
  CAT_CAPACITY VARCHAR(50),
  CAT_PROTOCOL VARCHAR(50),
  CAT_PROTOCOLDATE DATE,
  CAT_ORDER VARCHAR(50),
  CAT_ORDERDATE DATE,
  CAT_CATEGORY INTEGER,
  CAT_CATEGORYDATESTART DATE,
  CAT_CATEGORYDATESTOP DATE,
  CAT_NOTICEID INTEGER,
  CAT_FIRMID INTEGER,
  CAT_OBJID INTEGER,
  CAT_LAST CHAR(1)  DEFAULT "F",
  CAT_DELONUM VARCHAR(50),
  CAT_DELODATE DATE,
  CAT_CAPACITYINSIDE VARCHAR(50),
  CAT_CAPACITYOUTSIDE VARCHAR(50),
  CAT_BREAKDATE DATE,
  CAT_BREAKREASON VARCHAR(240),
  CAT_PROTOCOLORDER VARCHAR(100),
  CAT_PROTOCOLORDERDATE DATE,
  CAT_QUERYKMET VARCHAR(100),
  CAT_QUERYKMETDATE DATE,
  CAT_COMMENT VARCHAR(10000)
);
/*SQLStop*/

/*ManyStart>850*/
CREATE GENERATOR GEN_HIST_CATEGORIZE;
SET GENERATOR GEN_HIST_CATEGORIZE TO 0;
/*ManyStop*/

/*SQLStart>851*/
CREATE OR ALTER trigger CATEGORIZE_HIST_I_TR for CATEGORIZE_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_CATEGORIZE,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>852*/
GRANT ALL ON CATEGORIZE_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>853*/
CREATE TABLE CITY_KL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  CK_ID INTEGER,
  CK_TEXT VARCHAR(100)
);
/*SQLStop*/

/*ManyStart>854*/
CREATE GENERATOR GEN_HIST_CITY_KL;
SET GENERATOR GEN_HIST_CITY_KL TO 0;
/*ManyStop*/

/*SQLStart>855*/
CREATE OR ALTER trigger CITY_KL_HIST_I_TR for CITY_KL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_CITY_KL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>856*/
GRANT ALL ON CITY_KL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>857*/
CREATE TABLE FIRMS_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  F_ID INTEGER,
  F_NAME VARCHAR(240),
  F_DN VARCHAR(15),
  F_RESH VARCHAR(15),
  F_ADDR_CITY VARCHAR(30),
  F_ADDR_PLACE VARCHAR(240),
  F_TEL VARCHAR(100),
  F_COMMENT VARCHAR(240),
  F_MAN INTEGER,
  F_PRES INTEGER,
  F_BULSTAT VARCHAR(15),
  F_COURT VARCHAR(30),
  F_RSDELO VARCHAR(100),
  F_RSTOM VARCHAR(15),
  F_RSREG VARCHAR(15),
  F_PARTIDA VARCHAR(15),
  F_RSCOMENT VARCHAR(250),
  F_RSYEAR VARCHAR(15),
  F_CLEARNAME VARCHAR(240),
  F_MOBPHONE VARCHAR(15),
  F_EMAIL VARCHAR(200),
  F_FTYPE VARCHAR(15),
  F_ONLYPER CHAR(1)  DEFAULT "F",
  F_FLAG2 CHAR(1),
  F_NOTES BLOB SUB_TYPE 0,
  F_CITY INTEGER,
  F_RSDDATA DATE,
  F_MANAGERID INTEGER,
  F_FAX VARCHAR(100),
  F_OBL_ID INTEGER
);
/*SQLStop*/

/*ManyStart>858*/
CREATE GENERATOR GEN_HIST_FIRMS;
SET GENERATOR GEN_HIST_FIRMS TO 0;
/*ManyStop*/

/*SQLStart>859*/
CREATE OR ALTER trigger FIRMS_HIST_I_TR for FIRMS_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_FIRMS,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>860*/
GRANT ALL ON FIRMS_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>861*/
CREATE TABLE JK_KL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  JK_ID INTEGER,
  JK_TEXT VARCHAR(50)
);
/*SQLStop*/

/*ManyStart>862*/
CREATE GENERATOR GEN_HIST_JK_KL;
SET GENERATOR GEN_HIST_JK_KL TO 0;
/*ManyStop*/

/*SQLStart>863*/
CREATE OR ALTER trigger JK_KL_HIST_I_TR for JK_KL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_JK_KL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>864*/
GRANT ALL ON JK_KL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>865*/
CREATE TABLE KAT_KL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  KAT_ID INTEGER,
  KAT_TEXT VARCHAR(200),
  KAT_NUMKIND SMALLINT
);
/*SQLStop*/

/*ManyStart>866*/
CREATE GENERATOR GEN_HIST_KAT_KL;
SET GENERATOR GEN_HIST_KAT_KL TO 0;
/*ManyStop*/

/*SQLStart>867*/
CREATE OR ALTER trigger KAT_KL_HIST_I_TR for KAT_KL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_KAT_KL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>868*/
GRANT ALL ON KAT_KL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>869*/
CREATE TABLE LCSTYPE_NOM_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  LT_ID SMALLINT,
  LT_TEXT VARCHAR(100),
  LT_CHECK VARCHAR(1),
  LT_CURNUM INTEGER,
  LT_BHID INTEGER,
  LCS_TERM INTEGER,
  LT_TAXIDS VARCHAR(600),
  LT_TAXDESCRS VARCHAR(600),
  LT_NUMKIND SMALLINT
);
/*SQLStop*/

/*ManyStart>870*/
CREATE GENERATOR GEN_HIST_LCSTYPE_NOM;
SET GENERATOR GEN_HIST_LCSTYPE_NOM TO 0;
/*ManyStop*/

/*SQLStart>871*/
CREATE OR ALTER trigger LCSTYPE_NOM_HIST_I_TR for LCSTYPE_NOM_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_LCSTYPE_NOM,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>872*/
GRANT ALL ON LCSTYPE_NOM_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>873*/
CREATE TABLE LICENSES_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  L_ID INTEGER,
  L_KEY VARCHAR(40),
  L_OBJ INTEGER,
  L_FIRM INTEGER,
  L_TYPE VARCHAR(100),
  L_DATASTART DATE,
  L_DATAEND DATE,
  L_DTBREAK DATE,
  L_FACTNO VARCHAR(240),
  L_SAVE SMALLINT,
  L_NO VARCHAR(18),
  L_BHID INTEGER,
  L_COMENT VARCHAR(200),
  L_PRICE INTEGER,
  L_PROT VARCHAR(240),
  L_PART VARCHAR(100),
  L_STR VARCHAR(20),
  L_SANRAZR VARCHAR(100),
  L_TOM VARCHAR(50),
  L_ERASED CHAR(1)  DEFAULT 'F',
  L_KIND INTEGER,
  L_NOTICE INTEGER,
  L_NOSORT VARCHAR(50),
  L_DTBREAKREASON VARCHAR(240),
  L_DELONUM VARCHAR(100),
  L_DELODATE DATE,
  L_REGZH VARCHAR(100)
);
/*SQLStop*/

/*ManyStart>874*/
CREATE GENERATOR GEN_HIST_LICENSES;
SET GENERATOR GEN_HIST_LICENSES TO 0;
/*ManyStop*/

/*SQLStart>875*/
CREATE OR ALTER trigger LICENSES_HIST_I_TR for LICENSES_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_LICENSES,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>876*/
GRANT ALL ON LICENSES_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>877*/
CREATE TABLE NOTICETYPE_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  NOTICETYPE_ID INTEGER,
  NOTICETYPE_TEXT VARCHAR(240),
  NOTICETYPE_NUMKIND INTEGER
);
/*SQLStop*/

/*ManyStart>878*/
CREATE GENERATOR GEN_HIST_NOTICETYPE;
SET GENERATOR GEN_HIST_NOTICETYPE TO 0;
/*ManyStop*/

/*SQLStart>879*/
CREATE OR ALTER trigger NOTICETYPE_HIST_I_TR for NOTICETYPE_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_NOTICETYPE,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>880*/
GRANT ALL ON NOTICETYPE_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>881*/
CREATE TABLE NUMKINDDOC_NOM_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  NUMKIND_ID SMALLINT,
  NUMKIND_PREFIX VARCHAR(10),
  NUMKIND_USEPREFIX CHAR(1)  DEFAULT "N",
  NUMKIND_ACTIVE CHAR(1)  DEFAULT "T",
  NUMKIND_VALUE INTEGER
);
/*SQLStop*/

/*ManyStart>882*/
CREATE GENERATOR GEN_HIST_NUMKINDDOC_NOM;
SET GENERATOR GEN_HIST_NUMKINDDOC_NOM TO 0;
/*ManyStop*/

/*SQLStart>883*/
CREATE OR ALTER trigger NUMKINDDOC_NOM_HIST_I_TR for NUMKINDDOC_NOM_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_NUMKINDDOC_NOM,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>884*/
GRANT ALL ON NUMKINDDOC_NOM_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>885*/
CREATE TABLE OBJECTOWNER_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  OBJECTOWNER_ID INTEGER,
  OBJECTOWNER_OBJECTID INTEGER,
  OBJECTOWNER_OWNERID INTEGER
);
/*SQLStop*/

/*ManyStart>886*/
CREATE GENERATOR GEN_HIST_OBJECTOWNER;
SET GENERATOR GEN_HIST_OBJECTOWNER TO 0;
/*ManyStop*/

/*SQLStart>887*/
CREATE OR ALTER trigger OBJECTOWNER_HIST_I_TR for OBJECTOWNER_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_OBJECTOWNER,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>888*/
GRANT ALL ON OBJECTOWNER_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>889*/
CREATE TABLE OBJECTREGISTER_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  OR_ID INTEGER,
  OR_OBJECT INTEGER,
  OR_INDOCNOM VARCHAR(25),
  OR_NOMTXT VARCHAR(25),
  OR_DATE DATE,
  OR_DTSTART DATE,
  OR_DTSTOP DATE,
  OR_BREAKDATE DATE,
  OR_TYPE VARCHAR(50),
  OR_BLOB BLOB SUB_TYPE 0,
  OR_RTOM VARCHAR(15),
  OR_RPAGE VARCHAR(15),
  OR_PREVREGISTER VARCHAR(250),
  OR_BREAKREASON VARCHAR(250),
  OR_REJECTLETTER VARCHAR(25),
  OR_LASTFLAG CHAR(1),
  OR_NOTES BLOB SUB_TYPE 0,
  OR_FIRM INTEGER,
  OR_ACTIVITY VARCHAR(300),
  OR_TOBACCO CHAR(1)  DEFAULT 'F',
  OR_SPIRT CHAR(1)  DEFAULT 'F',
  OR_WTFROM VARCHAR(50),
  OR_WTTO VARCHAR(50),
  OR_CHARGETIME VARCHAR(100),
  OR_ERASED CHAR(1)  DEFAULT 'F',
  OR_NOMTXTSORT VARCHAR(50),
  OR_BREAKDATEREASON VARCHAR(240),
  OR_MANAGERID INTEGER,
  OR_FREEDAYS VARCHAR(240),
  OR_KIND INTEGER,
  OR_PAGE INTEGER,
  OR_ZZH VARCHAR(240),
  OR_ZZZ VARCHAR(240),
  OR_MD VARCHAR(240),
  OR_INBUILDING BOOLEAN,
  OR_NOTIN30M BOOLEAN
);
/*SQLStop*/

/*ManyStart>890*/
CREATE GENERATOR GEN_HIST_OBJECTREGISTER;
SET GENERATOR GEN_HIST_OBJECTREGISTER TO 0;
/*ManyStop*/

/*SQLStart>891*/
CREATE OR ALTER trigger OBJECTREGISTER_HIST_I_TR for OBJECTREGISTER_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_OBJECTREGISTER,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>892*/
GRANT ALL ON OBJECTREGISTER_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>893*/
CREATE TABLE OBJECTS_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  O_ID INTEGER,
  O_FIRM INTEGER,
  O_SID INTEGER,
  O_TYPE VARCHAR(30),
  O_NAME VARCHAR(240),
  O_ADDR_CITY VARCHAR(30),
  O_ADDR_PLACE VARCHAR(240),
  O_COMMENT VARCHAR(240),
  O_CHEF INTEGER,
  O_TEL VARCHAR(20),
  O_KATNUM SMALLINT,
  O_KATSTR VARCHAR(30),
  O_KATUD VARCHAR(30),
  O_KATPR VARCHAR(30),
  O_KATMS VARCHAR(30),
  O_PRREG VARCHAR(20),
  O_WTFROM VARCHAR(5),
  O_WTTO VARCHAR(5),
  O_PRRECL VARCHAR(20),
  O_RECLCOM VARCHAR(200),
  O_EXTCOM VARCHAR(200),
  O_ARREA REAL3,
  O_ZONA INTEGER  DEFAULT 0,
  O_WTMON VARCHAR(40),
  O_WTTHU VARCHAR(40),
  O_WTWED VARCHAR(40),
  O_WTTUS VARCHAR(40),
  O_WTFRE VARCHAR(40),
  O_WTSAT VARCHAR(40),
  O_WTSUN VARCHAR(40),
  O_CHTMON VARCHAR(40),
  O_CHTTHU VARCHAR(40),
  O_CHTWED VARCHAR(40),
  O_CHTTUS VARCHAR(40),
  O_CHTFRE VARCHAR(40),
  O_CHTSAT VARCHAR(40),
  O_CHTSUN VARCHAR(40),
  O_CHARGETIME VARCHAR(100),
  O_MARKETAREA REAL3,
  O_FLAGS CHAR(20),
  O_OUTOBJECTS VARCHAR(100),
  O_ULID INTEGER,
  O_ULNOM VARCHAR(240),
  O_JK VARCHAR(50),
  O_RAJON VARCHAR(50),
  O_MAINWORKS VARCHAR(250),
  O_NOTES BLOB SUB_TYPE 0,
  O_BLOCK VARCHAR(240),
  O_NUM VARCHAR(50),
  O_TOM VARCHAR(50),
  O_TOMDATE DATE,
  O_CITY INTEGER,
  O_JKID INTEGER,
  O_KIND INTEGER,
  O_DEPUTYID INTEGER,
  O_KATID INTEGER,
  O_KATSTART DATE,
  O_KATSTOP DATE,
  O_OBL_ID INTEGER
);
/*SQLStop*/

/*ManyStart>894*/
CREATE GENERATOR GEN_HIST_OBJECTS;
SET GENERATOR GEN_HIST_OBJECTS TO 0;
/*ManyStop*/

/*SQLStart>895*/
CREATE OR ALTER trigger OBJECTS_HIST_I_TR for OBJECTS_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_OBJECTS,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>896*/
GRANT ALL ON OBJECTS_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>897*/
CREATE TABLE OBJTYPE_NOM_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  OT_ID SMALLINT,
  OT_TEXT VARCHAR(100),
  OT_CHECK VARCHAR(1)
);
/*SQLStop*/

/*ManyStart>898*/
CREATE GENERATOR GEN_HIST_OBJTYPE_NOM;
SET GENERATOR GEN_HIST_OBJTYPE_NOM TO 0;
/*ManyStop*/

/*SQLStart>899*/
CREATE OR ALTER trigger OBJTYPE_NOM_HIST_I_TR for OBJTYPE_NOM_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_OBJTYPE_NOM,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>900*/
GRANT ALL ON OBJTYPE_NOM_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>901*/
CREATE TABLE OBL_KL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  OBL_ID INTEGER,
  OBL_TEXT VARCHAR(100)
);
/*SQLStop*/

/*ManyStart>902*/
CREATE GENERATOR GEN_HIST_OBL_KL;
SET GENERATOR GEN_HIST_OBL_KL TO 0;
/*ManyStop*/

/*SQLStart>903*/
CREATE OR ALTER trigger OBL_KL_HIST_I_TR for OBL_KL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_OBL_KL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>904*/
GRANT ALL ON OBL_KL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>905*/
CREATE TABLE PAYMENT_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  P_ID INTEGER,
  P_NUM SMALLINT  DEFAULT 0,
  P_DATA DATE,
  P_DTSTART DATE,
  P_DTSTOP DATE,
  P_VAL REAL3,
  P_LIXVA REAL3,
  P_TOTAL REAL3,
  P_DDS FLOAT,
  P_CARRY REAL3  DEFAULT 0,
  P_FLAG INTEGER,
  P_TOID INTEGER,
  P_FID INTEGER,
  P_FNUM VARCHAR(50),
  P_FDATE DATE,
  P_UID INTEGER,
  P_COMMENT VARCHAR(250),
  P_FLAGS CHAR(20)  DEFAULT "00000000000000000000",
  P_TYPE INTEGER  DEFAULT 1,
  P_TAXKASA INTEGER,
  P_FIRMID INTEGER,
  P_TODATE DATE,
  P_PAYTYPE SMALLINT,
  P_USERID INTEGER,
  P_OPERATORNAME VARCHAR(75),
  P_STATUS SMALLINT,
  P_MASTERNUM SMALLINT);
/*SQLStop*/

/*ManyStart>906*/
CREATE GENERATOR GEN_HIST_PAYMENT;
SET GENERATOR GEN_HIST_PAYMENT TO 0;
/*ManyStop*/

/*SQLStart>907*/
CREATE OR ALTER trigger PAYMENT_HIST_I_TR for PAYMENT_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_PAYMENT,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>908*/
GRANT ALL ON PAYMENT_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>909*/
CREATE TABLE RELATEDDOCS_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  RD_ID INTEGER,
  RD_NUM SMALLINT,
  RD_TYPE VARCHAR(50),
  RD_NOMTXT VARCHAR(25),
  RD_DATE DATE,
  RD_COMENT VARCHAR(250),
  RD_WRITER VARCHAR(150)
);
/*SQLStop*/

/*ManyStart>910*/
CREATE GENERATOR GEN_HIST_RELATEDDOCS;
SET GENERATOR GEN_HIST_RELATEDDOCS TO 0;
/*ManyStop*/

/*SQLStart>911*/
CREATE OR ALTER trigger RELATEDDOCS_HIST_I_TR for RELATEDDOCS_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_RELATEDDOCS,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>912*/
GRANT ALL ON RELATEDDOCS_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>913*/
CREATE TABLE SEARCHTUNE_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  SEARCHTUNE_REG INTEGER,
  SEARCHTUNE_USER INTEGER,
  SEARCHTUNE_NUM INTEGER,
  SEARCHTUNE_TITLE VARCHAR(100),
  SEARCHTUNE_BLOB BLOB SUB_TYPE 1
);
/*SQLStop*/

/*ManyStart>914*/
CREATE GENERATOR GEN_HIST_SEARCHTUNE;
SET GENERATOR GEN_HIST_SEARCHTUNE TO 0;
/*ManyStop*/

/*SQLStart>915*/
CREATE OR ALTER trigger SEARCHTUNE_HIST_I_TR for SEARCHTUNE_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_SEARCHTUNE,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>916*/
GRANT ALL ON SEARCHTUNE_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>917*/
CREATE TABLE SN_KL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  SN_NUM INTEGER,
  SN_ID INTEGER,
  SN_TEXT VARCHAR(100)
);
/*SQLStop*/

/*ManyStart>918*/
CREATE GENERATOR GEN_HIST_SN_KL;
SET GENERATOR GEN_HIST_SN_KL TO 0;
/*ManyStop*/

/*SQLStart>919*/
CREATE OR ALTER trigger SN_KL_HIST_I_TR for SN_KL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_SN_KL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>920*/
GRANT ALL ON SN_KL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>921*/
CREATE TABLE SYSTEM_STRINGS_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  SYS_ID SMALLINT,
  SYS_STR VARCHAR(120)
);
/*SQLStop*/

/*ManyStart>922*/
CREATE GENERATOR GEN_HIST_SYSTEM_STRINGS;
SET GENERATOR GEN_HIST_SYSTEM_STRINGS TO 0;
/*ManyStop*/

/*SQLStart>923*/
CREATE OR ALTER trigger SYSTEM_STRINGS_HIST_I_TR for SYSTEM_STRINGS_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_SYSTEM_STRINGS,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>924*/
GRANT ALL ON SYSTEM_STRINGS_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>925*/
CREATE TABLE TAXES_KL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  TAX_ID INTEGER,
  TAX_KASAID INTEGER,
  TAX_TEXT VARCHAR(240),
  TAX_DESC VARCHAR(240)
);
/*SQLStop*/

/*ManyStart>926*/
CREATE GENERATOR GEN_HIST_TAXES_KL;
SET GENERATOR GEN_HIST_TAXES_KL TO 0;
/*ManyStop*/

/*SQLStart>927*/
CREATE OR ALTER trigger TAXES_KL_HIST_I_TR for TAXES_KL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_TAXES_KL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>928*/
GRANT ALL ON TAXES_KL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>929*/
CREATE TABLE TAXI_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  TAXI_ID INTEGER,
  TAXI_TYPE INTEGER,
  TAXI_DEALER INTEGER,
  TAXI_CAR INTEGER,
  TAXI_REGNUM VARCHAR(100),
  TAXI_CARTERNUM VARCHAR(100),
  TAXI_DATESTART DATE,
  TAXI_DATESTOP DATE,
  TAXI_BREAK DATE,
  TAXI_BREAKCOMMENT VARCHAR(240),
  TAXI_COMMENT VARCHAR(240),
  TAXI_ERASED BOOLEAN  DEFAULT 0,
  TAXI_DUTYPERSONID INTEGER,
  TAXI_DELONUM VARCHAR(50),
  TAXI_DELODATE DATE
);
/*SQLStop*/

/*ManyStart>930*/
CREATE GENERATOR GEN_HIST_TAXI;
SET GENERATOR GEN_HIST_TAXI TO 0;
/*ManyStop*/

/*SQLStart>931*/
CREATE OR ALTER trigger TAXI_HIST_I_TR for TAXI_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_TAXI,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>932*/
GRANT ALL ON TAXI_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>933*/
CREATE TABLE TAXITYPE_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  TAXITYPE_ID INTEGER,
  TAXITYPE_TEXT VARCHAR(240),
  TAXITYPE_NUMKIND INTEGER
);
/*SQLStop*/

/*ManyStart>934*/
CREATE GENERATOR GEN_HIST_TAXITYPE;
SET GENERATOR GEN_HIST_TAXITYPE TO 0;
/*ManyStop*/

/*SQLStart>935*/
CREATE OR ALTER trigger TAXITYPE_HIST_I_TR for TAXITYPE_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_TAXITYPE,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>936*/
GRANT ALL ON TAXITYPE_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>937*/
CREATE TABLE TERMPERM_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  TP_ID INTEGER,
  TP_NOMTXT VARCHAR(30),
  TP_DATE DATE,
  TP_DTSTART DATE,
  TP_DTSTOP DATE,
  TP_TERM INTEGER,
  TP_FID INTEGER,
  TP_KWITNOM VARCHAR(30),
  TP_STOCK VARCHAR(200),
  TP_EQUIPMENT VARCHAR(200),
  TP_PLACE VARCHAR(200),
  TP_ERASED CHAR(1)  DEFAULT 'F',
  TP_TYPE INTEGER,
  TP_AREA VARCHAR(50),
  TP_NOMTXTSORT VARCHAR(50),
  TP_DELONUM VARCHAR(50),
  TP_DELODATE DATE,
  TP_NOTICE INTEGER,
  TP_REJECTED CHAR(1)  DEFAULT "F",
  TP_REJECTEDREASON VARCHAR(240),
  TP_QUERY VARCHAR(200),
  TP_DTQUERY DATE,
  TP_ANCART VARCHAR(100),
  TP_REGZH VARCHAR(100),
  TP_COMMENT VARCHAR(240),
  TP_BREAKDATE DATE,
  TP_BREAKREASON VARCHAR(240),
  TP_PROTOCOL VARCHAR(100),
  TP_MANAGER INTEGER,
  TP_NOTICENUM VARCHAR(100),
  TP_NOTICETOM VARCHAR(50),
  TP_NOTICEDATE DATE,
  TP_STATIONARYOBJECT VARCHAR(240),
  TP_PRICE REAL3,
  TP_PRICEMONTH BOOLEAN,
  TP_WORKTIME VARCHAR(240),
  TP_DISCOUNT REAL3,
  TP_DISCOUNTTEXT VARCHAR(240),
  TP_ADSNUMBER INTEGER,
  TP_ADSWIDTH FLOAT,
  TP_ADSHEIGHT FLOAT,
  TP_ADSAREA FLOAT,
  TP_ADSFROM VARCHAR(240),
  TP_ADSOUTNUMBER VARCHAR(240),
  TP_ADSOUTDATE DATE  
);
/*SQLStop*/

/*ManyStart>938*/
CREATE GENERATOR GEN_HIST_TERMPERM;
SET GENERATOR GEN_HIST_TERMPERM TO 0;
/*ManyStop*/

/*SQLStart>939*/
CREATE OR ALTER trigger TERMPERM_HIST_I_TR for TERMPERM_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_TERMPERM,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>940*/
GRANT ALL ON TERMPERM_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>941*/
CREATE TABLE TP_KL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  TK_ID INTEGER,
  TK_TEXT VARCHAR(100),
  TK_NUMKIND SMALLINT
);
/*SQLStop*/

/*ManyStart>942*/
CREATE GENERATOR GEN_HIST_TP_KL;
SET GENERATOR GEN_HIST_TP_KL TO 0;
/*ManyStop*/

/*SQLStart>943*/
CREATE OR ALTER trigger TP_KL_HIST_I_TR for TP_KL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_TP_KL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>944*/
GRANT ALL ON TP_KL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>945*/
CREATE TABLE UL_KL_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  UL_ID INTEGER,
  UL_TEXT VARCHAR(50)
);
/*SQLStop*/

/*ManyStart>946*/
CREATE GENERATOR GEN_HIST_UL_KL;
SET GENERATOR GEN_HIST_UL_KL TO 0;
/*ManyStop*/

/*SQLStart>947*/
CREATE OR ALTER trigger UL_KL_HIST_I_TR for UL_KL_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_UL_KL,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>948*/
GRANT ALL ON UL_KL_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>949*/
CREATE TABLE USERRIGHTS_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  USERRIGHTS_ID INTEGER,
  USERRIGHTS_BLOB BLOB SUB_TYPE 1
);
/*SQLStop*/

/*ManyStart>950*/
CREATE GENERATOR GEN_HIST_USERRIGHTS;
SET GENERATOR GEN_HIST_USERRIGHTS TO 0;
/*ManyStop*/

/*SQLStart>951*/
CREATE OR ALTER trigger USERRIGHTS_HIST_I_TR for USERRIGHTS_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_USERRIGHTS,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>952*/
GRANT ALL ON USERRIGHTS_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>953*/
CREATE TABLE ZONES_HIST (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HISTORY_DATE DATE   NOT NULL,
  HISTORY_TYPE INTEGER   NOT NULL,
  HISTORY_GROUP INTEGER  DEFAULT 0 NOT NULL,
  USER_ID INTEGER   NOT NULL,
  Z_ID INTEGER,
  Z_TXT VARCHAR(100),
  Z_DESCR VARCHAR(240),
  Z_COEF NUMERIC(15,4)
);
/*SQLStop*/

/*ManyStart>954*/
CREATE GENERATOR GEN_HIST_ZONES;
SET GENERATOR GEN_HIST_ZONES TO 0;
/*ManyStop*/

/*SQLStart>955*/
CREATE OR ALTER trigger ZONES_HIST_I_TR for ZONES_HIST 
active before insert or update position 0 
as 
begin 
  if (new.ID is null) then 
    new.ID = gen_id(GEN_HIST_ZONES,1); 
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end 
/*SQLStop*/

/*ManyStart>956*/
GRANT ALL ON ZONES_HIST TO PUBLIC;
/*ManyStop*/

/*SQLStart>957*/
CREATE TABLE HISTORY_TYPES (
  ID INTEGER   NOT NULL PRIMARY KEY,
  HT_TEXT VARCHAR(200)   NOT NULL
);
/*SQLStop*/

/*ManyStart>958*/
GRANT ALL ON HISTORY_TYPES TO PUBLIC;
/*ManyStop*/

/*SQLStart>959*/
INSERT INTO HISTORY_TYPES values (1, '');
/*SQLStop*/

/*SQLStart>960*/
INSERT INTO HISTORY_TYPES values (2, '');
/*SQLStop*/

/*SQLStart>961*/
INSERT INTO HISTORY_TYPES values (3, '');
/*SQLStop*/

/*SQLStart>962*/
INSERT INTO HISTORY_TYPES values (4, ' -   ');
/*SQLStop*/

/*SQLStart>963*/
CREATE TABLE GROUP_CHECK (
    GROUP_ID    INTEGER NOT NULL,
    TABLE_NAME  VARCHAR(100) NOT NULL,
    TABLE_ID    INTEGER NOT NULL,
    EVENT_DATE  DATE
);
/*SQLStop*/

/*SQLStart>964*/
ALTER TABLE GROUP_CHECK ADD CONSTRAINT PK_GROUP_CHECK PRIMARY KEY (GROUP_ID, TABLE_NAME, TABLE_ID);
/*SQLStop*/

/*SQLStart>965*/
CREATE OR ALTER trigger group_check_bi0 for group_check
active before insert position 0
AS
begin
  if (new.event_date is null) then
    new.event_date = current_timestamp;
  new.table_name = upper(new.table_name);
end
/*SQLStop*/

/*SQLStart>966*/
GRANT ALL ON GROUP_CHECK TO PUBLIC;
/*SQLStop*/

/*SQLStart>967*/
create or alter procedure GROUPCHECK (
    AGROUPID integer,
    ATABLE varchar(200),
    ATABLEID integer,
    AONLYCHECK integer)
returns (
    RESULT integer)
as
declare variable COUNTCHECK integer;
begin
  result=1;
  select count(*) from group_check where
    (GROUP_ID=:agroupid) and
    (TABLE_NAME=:atable) and
    (TABLE_ID=:atableid)
  into :countcheck;

  if (:countcheck < 1) then
    begin
      if (:aonlycheck = 0) then
        begin
          INSERT INTO GROUP_CHECK (GROUP_ID, TABLE_NAME, TABLE_ID)
          VALUES (:agroupid, :atable, :atableid);
        end
      result=0;
    end
  suspend;
end
/*SQLStop*/

/*SQLStart>968*/
GRANT execute ON PROCEDURE groupcheck TO PUBLIC;
/*SQLStop*/

/*SQLStart>969*/
CREATE INDEX AODOCINFO_HIST_HG ON AODOCINFO_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>970*/
CREATE INDEX BLANKS_HIST_HG ON BLANKS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>971*/
CREATE INDEX BLOBINFO_HIST_HG ON BLOBINFO_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>972*/
CREATE INDEX CARDRIVERS_HIST_HG ON CARDRIVERS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>973*/
CREATE INDEX CARMARK_HIST_HG ON CARMARK_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>974*/
CREATE INDEX CARMODEL_HIST_HG ON CARMODEL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>975*/
CREATE INDEX CARS_HIST_HG ON CARS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>976*/
CREATE INDEX CATEGORIZE_HIST_HG ON CATEGORIZE_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>977*/
CREATE INDEX CITY_KL_HIST_HG ON CITY_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>978*/
CREATE INDEX FIRMS_HIST_HG ON FIRMS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>979*/
CREATE INDEX JK_KL_HIST_HG ON JK_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>980*/
CREATE INDEX KAT_KL_HIST_HG ON KAT_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>981*/
CREATE INDEX LCSTYPE_NOM_HIST_HG ON LCSTYPE_NOM_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>982*/
CREATE INDEX LICENSES_HIST_HG ON LICENSES_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>983*/
CREATE INDEX NOTICETYPE_HIST_HG ON NOTICETYPE_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>984*/
CREATE INDEX NUMKINDDOC_NOM_HIST_HG ON NUMKINDDOC_NOM_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>985*/
CREATE INDEX OBJECTOWNER_HIST_HG ON OBJECTOWNER_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>986*/
CREATE INDEX OBJECTREGISTER_HIST_HG ON OBJECTREGISTER_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>987*/
CREATE INDEX OBJECTS_HIST_HG ON OBJECTS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>988*/
CREATE INDEX OBJTYPE_NOM_HIST_HG ON OBJTYPE_NOM_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>989*/
CREATE INDEX OBL_KL_HIST_HG ON OBL_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>990*/
CREATE INDEX PAYMENT_HIST_HG ON PAYMENT_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>991*/
CREATE INDEX RELATEDDOCS_HIST_HG ON RELATEDDOCS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>992*/
CREATE INDEX SEARCHTUNE_HIST_HG ON SEARCHTUNE_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>993*/
CREATE INDEX SN_KL_HIST_HG ON SN_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>994*/
CREATE INDEX SYSTEM_STRINGS_HIST_HG ON SYSTEM_STRINGS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>995*/
CREATE INDEX TAXES_KL_HIST_HG ON TAXES_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>996*/
CREATE INDEX TAXI_HIST_HG ON TAXI_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>997*/
CREATE INDEX TAXITYPE_HIST_HG ON TAXITYPE_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>998*/
CREATE INDEX TERMPERM_HIST_HG ON TERMPERM_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>999*/
CREATE INDEX TP_KL_HIST_HG ON TP_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>1000*/
CREATE INDEX UL_KL_HIST_HG ON UL_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>1001*/
CREATE INDEX USERRIGHTS_HIST_HG ON USERRIGHTS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>1002*/
CREATE INDEX ZONES_HIST_HG ON ZONES_HIST (HISTORY_GROUP);
/*SQLStop*/

/*DLLStart>1003*/
DLLName=upd049.dll
DLLProc=DoIt
/*DLLStop*/

/*SQLStart>1004*/
delete from system_strings where SYS_ID = 0;
/*SQLStop*/

/*SQLStart>1005*/
insert into system_strings (SYS_ID,SYS_STR) values (0,'1.5.49.1');
/*SQLStop*/
