/*ALIAS>prop_db*/
/*Hist_TBL>SQL_UPDATES_INCOMES*/

/*SQLStart>7000*/
create Table IncUsers (
  U_ID smallint not null,
  U_NAME varchar(120),
  U_SectID smallint,
  primary key (u_id)
)
/*SQLStop>7000*/

/*SQLStart>7001*/
create table Sections (
  sect_id smallint not null,
  sect_name varchar(45),
  primary key (sect_id)
)
/*SQLStop>7001*/

/*SQLStart>7002*/
create table TakingType (
  TT_ID smallint not null,
  TT_Text varchar(100),
  TT_TAXID integer,
  TT_TaxText varchar(200),
  TT_OnlySign char(1),
  primary key (TT_ID)
)
/*SQLStop>7002*/

/*SQLStart>7003*/
CREATE PROCEDURE ADD_INCUSER (
  U_ID SMALLINT,
  U_RNM VARCHAR(72)
)  AS  
DECLARE VARIABLE res smallint  ; 
BEGIN
  select U_id from IncUsers
  where U_id = :U_id
  into :res;
  
  if (:res is Null) then
    begin
      insert into IncUsers (U_id, U_name)
      values (:U_Id,:U_RNM);
    end
  else
    begin
      update IncUsers set  U_name = :U_RNM
      where U_id = :U_ID ;
    end
END
/*SQLStop>7003*/

/*SQLStart>7005*/
create generator TakingID_GEN;
/*SQLStop>7005*/

/*SQLStart>7006*/
create table Taking (
  T_ID integer not null primary key,
  T_TTID smallint,
  T_GenerateDate date,
  T_AppCode char(1) DEFAULT "V",
  T_AppID1 integer DEFAULT 0,
  T_AppID2 integer DEFAULT 0,
  T_AppID3 integer DEFAULT 0,
  T_AppID4 integer DEFAULT 0,
  T_OperatorID smallint,
  T_SecondType varchar(255),
  T_ReasonDate date,
  T_ReasonNum varchar(25),
  T_Reason varchar(255),
  T_ValidToDate date,
  T_MustPayDate date,
  T_DutySum Acs_Double,
  T_DDSPercent Acs_Double,
  T_DutyDDS Acs_Double,
  T_DDSPercentID smallint, 
  T_Comment varchar(255),
  T_State smallint default 0, 
  T_AnulDate date,
  T_AnulOperatorID smallint,
  T_AnulReason varchar(255),
  T_PersonID integer,
  T_IsTax smallint,
  T_OnlySign char(1)
)
/*SQLStop>7006*/

/*SQLStart>7007*/
CREATE TRIGGER TAKINGBI FOR TAKING BEFORE INSERT POSITION 0 as
begin
  NEW.T_ID = GEN_ID(TakingID_GEN, 1);
  NEW.T_GenerateDate = "NOW";
  if (NEW.T_ReasonDate < "01.01.1900") then
    NEW.T_ReasonDate =  "NOW";
  if (NEW.T_MustPayDate < "01.01.1900") then
    NEW.T_MustPayDate =  "01.01.2100";
  if (NEW.T_ValidToDate < "01.01.1900") then
    NEW.T_ValidToDate =  "01.01.2100";

  if ((NEW.T_APPID1 = 0) and (NEW.T_APPID2 = 0) and (NEW.T_APPID3 = 0) and (NEW.T_APPID3 = 0)) then
    NEW.T_APPID1 = NEW.T_ID;
end
/*SQLStop>7007*/

/*SQLStart>7008*/
create Table PayTaking (
  PT_ID integer not null,
  PT_NUM smallint not null,
  PT_PayDate date,
  PT_ClearPayDate date,
  PT_PayDocNum varchar(20),
  PT_PayWay smallint,
  PT_ExpectedSum Acs_Double,
  PT_ExpectedDDS Acs_Double,
  PT_PaySum Acs_Double,
  PT_PayDDS Acs_Double,
  PT_PayDDSPercent Acs_Double,
  PT_RealPaySum Acs_Double,
  PT_RealDDSSum Acs_Double,
  PT_InID integer,
  PT_OperatorID smallint,
  PT_Text varchar(200),
  PT_PayStatus smallint,
  PT_ANULNUM smallint default -1,
  PT_ExternalID1 integer default 0,
  PT_ExternalID2 integer default 0,
  PRIMARY KEY (PT_ID, PT_NUM)
)
/*SQLStop>7008*/

/*SQLStart>7009*/
CREATE TRIGGER PayTakingBI FOR PayTAKING BEFORE INSERT POSITION 0 as
declare variable cnt smallint;
declare variable id integer;
begin
  id = new.PT_ID;
  select max(PT_NUM) from PayTaking where PT_ID = :id into :cnt;
  if (cnt is null) then
    cnt = 0;
  else
    cnt = cnt + 1;
  NEW.PT_NUM = cnt;
  if (NEW.PT_PayDate < "01.01.1900") then
    NEW.PT_PayDate = "NOW";
  NEW.PT_ClearPayDate = AStripTime(NEW.PT_PayDate);
end
/*SQLStop>7009*/

/*ManyStart>7010*/
insert into TakingType(TT_ID, TT_TEXT) values (1, ' ');
/*ManyStop>7010*/

/*SQLStart>7011*/
create Table TakingTaxOrder (
  TTO_TID integer not null,
  TTo_TOID integer not null,
  primary key (TTO_TID, TTO_TOID)
)
/*SQLStop>7011*/

/*SQLStart>7012*/
create table TakingSums (
  TakingID integer not null,
  TakingExpectedSum Acs_Double,
  TakingPaySum Acs_Double,
  TakingExpectedDDS Acs_Double,
  TakingPayDDS Acs_Double,
  primary key (TakingID)
)
/*SQLStop>7012*/


/*SQLStart>7013*/
CREATE PROCEDURE TAKINGUPDATESTATE (
  TAKINGID INTEGER
)  AS
declare variable diff numeric(15,3);
declare variable paysum numeric(15,3);
declare variable expectedsum numeric(15,3);
declare variable sign char(1);
declare variable paycnt integer;

declare variable TAKINGEXPECTEDSUM numeric(15,3);
declare variable TAKINGPAYSUM numeric(15,3);
declare variable TAKINGEXPECTEDDDS numeric(15,3);
declare variable TAKINGPAYDDS numeric(15,3);
declare variable recFound smallint;
begin

  select sum(PT_ExpectedSum), sum(PT_PaySum), sum(PT_ExpectedDDS), sum(PT_PayDDS)
  from PayTaking
  where PT_ID = :TAKINGID
  into :TAKINGEXPECTEDSUM, :TAKINGPAYSUM, :TAKINGEXPECTEDDDS, :TAKINGPAYDDS;

  select count(TakingID) from TakingSums
  where TakingID = :TakingID
  into :recFound;

  if (recFound = 0) then
  begin
    insert into TakingSums (TakingID, TakingExpectedSum, TakingPaySum, TakingExpectedDDS, TakingPayDDS)
    values (:TakingID, :TakingExpectedSum, :TakingPaySum, :TakingExpectedDDS, :TakingPayDDS);
  end
  else
  begin
    update TakingSums set
      TakingExpectedSum = :TakingExpectedSum,
      TakingPaySum = :TakingPaySum,
      TakingExpectedDDS = :TakingExpectedDDS,
      TakingPayDDS = :TakingPayDDS
    where
      TakingID = :TakingID;
  end


  select T_OnlySign from Taking where T_ID = :TAKINGID into :sign;
  if (sign = "F") then
  begin
    select sum(PT_ExpectedSum), sum(PT_PaySum) from PayTaking where PT_ID = :TakingID into :expectedsum , :paysum;
    diff = expectedsum - paysum;
    if ((paysum >= 0.00) and (paysum < 0.01)) then
      update Taking set T_STATE = 0 where T_ID = :TakingID;
    else if (paysum < expectedsum) then
      update Taking set T_STATE = 0 where T_ID = :TakingID;
    else if ((diff >= 0.00) and (diff < 0.01)) then
      update Taking set T_STATE = 2 where T_ID = :TakingID;
    else if (diff < 0.00)  then
      update Taking set T_STATE = 3 where T_ID = :TakingID;
  end else
  begin
    select count(*) from PayTaking where PT_ID = :TakingID into :paycnt;
    if (paycnt = 1) then
      update Taking set T_STATE = 0 where T_ID = :TakingID;
    else if (paycnt = 2) then
      update Taking set T_STATE = 2 where T_ID = :TakingID;
  end
end
/*SQLStop>7013*/

/*SQLStart>7014*/
CREATE TRIGGER PayTaking_UPDATE_STATE FOR PayTAKING AFTER INSERT POSITION 0 as
begin
  execute procedure TakingUpdateState(NEW.PT_ID);
end
/*SQLStop>7014*/

/*SQLStart>7015*/
CREATE TRIGGER PayTaking_PriceUpdate FOR PayTAKING AFTER UPDATE POSITION 0 as
begin
  execute procedure TakingUpdateState(NEW.PT_ID);
end
/*SQLStop>7015*/

/*SQLStart>7016*/
create index TAKINGAPPIDX on TAKING (T_APPCODE,T_APPID1,T_APPID2,T_APPID3,T_APPID4)
/*SQLStop>*/

/*SQLStart>7017*/
create index TakingPerIDx on TAKING (T_PERsonID)
/*SQLStop>*/

/*SQLStart>7018*/
CREATE TRIGGER PayTaking_UPDATE_STATE_DEL FOR PayTAKING AFTER DELETE POSITION 0 as
begin
  execute procedure TakingUpdateState(OLD.PT_ID);
end
/*SQLStop>7018*/

/*SQLStart>7019*/
CREATE TRIGGER Taking_UPDATE FOR TAKING AFTER UPDATE POSITION 0 as
begin
  if (new.T_DUTYSUM <> old.T_DUTYSUM) then
    execute procedure TakingUpdateState(OLD.T_ID);
end
/*SQLStop>7019*/


/*SQLStart>7020*/
insert into Sections (SECT_ID, SECT_NAME) values (0, " ");
/*SQLStop>7020*/

/*ManyStart>7021*/
grant all on TakingType to public;
grant all on Taking to public;
grant all on PayTaking to public;
grant all on IncUsers to public;
grant all on Sections to public;
grant all on TakingTaxOrder to public;
grant execute on procedure TakingUpdateState to public;
grant execute on procedure ADD_INCUSER to public;
grant all on TakingSums to public;
/*ManyStop>7021*/

/*SQLStart>7022*/
insert into System_Strings (sys_id, sys_str) values (14001, '1');
/*SQLStop>7022*/


