/*ALIAS>prop_db*/

/*SQLStart>2717*/
ALTER procedure INVOICEADDHEADER (
    IN_PERID integer,
    IN_PAYID integer,
    IN_PAYTYPE char(1),
    IN_PAYSUM numeric(15,2),
    IN_PAYCLEARSUM numeric(15,2),
    IN_PAYDDS numeric(15,2),
    IN_PAYLIHVI numeric(15,2),
    IN_PAYWAY char(1),
    IN_COMMENT varchar(250),
    IN_PAYTEXT varchar(250),
    IN_OPERATORID integer,
    IN_OBMOL varchar(50),
    IN_PERPAYFROM varchar(50),
    IN_PAYNODDSSUM numeric(15,2),
    IN_PAYDDSSUM numeric(15,2),
    IN_FACTOR numeric(15,2),
    IN_PAYDATE date,
    IN_REALPAYDATE date,
    IN_NODDSDESCR varchar(255),
    IN_DDSEVENTDATE date)
returns (
    IN_ID integer)
as
declare variable IN_OPERATORNAME varchar(140);
declare variable IN_PERNAME varchar(140);
declare variable IN_PERADDR varchar(250);
declare variable IN_PERNM varchar(30);
declare variable IN_PEREGN varchar(15);
declare variable IN_PERDANN varchar(10);
declare variable IN_PERMOLNAME varchar(140);
declare variable IN_PERINDDS varchar(15);
declare variable IN_PER_ADDR_CORESP varchar(250);
declare variable IN_PER_TDNAP varchar(20);
declare variable IN_PER_TDNAP_ADDR varchar(50);
begin
  /* wzima se imeto na kasiera */
  select USER_STR from users
  where USER_ID = :IN_OperatorID
  into :IN_OperatorName;

  /* wzimat se dannite na personata */
  select PerName, PerEgn, PerDanN, PerAddr, PerNM, PerMolName, PerINDDS, PerAddr_Coresp, PerTDNap, PerTDNap_Addr
  from PersonGetInfo(:IN_PerID)
  into :IN_PerName, :IN_PerEgn, :IN_PerDanN, :IN_PerAddr, :IN_PerNM, :IN_PERMOLNAME, :IN_PERINDDS,
  :IN_PER_ADDR_CORESP, :IN_PER_TDNAP, :IN_PER_TDNAP_ADDR;

  if (IN_PAYDATE < "01.01.1990" ) then
    IN_PayDate = "NOW";

  if (IN_DDSEVENTDATE < "01.01.1990" ) then
    IN_DDSEVENTDATE = IN_PayDate;
  
  IN_ID = GEN_ID(IN_ID_GEN, 1);
  insert into Invoices (IN_ID, IN_PERID, IN_PERNAME, IN_PERADDR, IN_PERNM, IN_PEREGN,
                        IN_PERDANN, IN_PERMOLNAME, IN_PAYTYPE, IN_PAYTEXT, IN_PAYID,
                        IN_PAYSUM, IN_PAYDDS, IN_OPERATORID, IN_OPERATORNAME, IN_PAYLIHVI,
                        IN_PAYWAY, IN_ANUL, IN_COMMENT, IN_PAYCLEARSUM,
                        IN_OBMOL, IN_REAL, IN_PerPayFrom,
                        IN_PayDDSSum, IN_PayNoDDSSum, IN_FACTOR, IN_PAYDATE, IN_REALPAYDATE, 
                        IN_PERINDDS, IN_FLAG2007, IN_NODDSDESCR, IN_DDSEVENTDATE,
                        IN_PER_ADDR_CORESP, IN_PER_TDNAP, IN_PER_TDNAP_ADDR)
  values               (:IN_ID, :IN_PERID, :IN_PERNAME, :IN_PERADDR, :IN_PERNM, :IN_PEREGN,
                        :IN_PERDANN, :IN_PERMOLNAME, :IN_PAYTYPE, :IN_PAYTEXT, :IN_PAYID,
                        :IN_PAYSUM, :IN_PAYDDS, :IN_OPERATORID, :IN_OPERATORNAME, :IN_PAYLIHVI,
                        :IN_PAYWAY, "A", :IN_COMMENT, :IN_PAYCLEARSUM,
                        :IN_OBMOL, "F", :IN_PerPayFrom,
                        :IN_PayDDSSum, :IN_PayNoDDSSum, :IN_FACTOR, :IN_PAYDATE, :IN_REALPAYDATE,
                        :IN_PERINDDS, "T", :IN_NODDSDESCR, :IN_DDSEVENTDATE,
                        :IN_PER_ADDR_CORESP, :IN_PER_TDNAP, :IN_PER_TDNAP_ADDR);
  
  suspend;
end
/*SQLStop*/

/*SQLStart>2718*/
update system_strings set sys_str = '6.7.223.1' where sys_id = 1401;  /*BackOffice*/
/*SQLStop*/
