/*ALIAS>prop_db*/

/*SQLStart>2440*/
	ALTER TABLE DOCCOUNTS
	ADD DC_LOCKED INTEGER
	DEFAULT 0 
/*SQLStop>*/

/*SQLStart>2442*/
	CREATE EXCEPTION EX_DEADLOCK 'Fail to lock section'
/*SQLStop>*/
	CREATE OR ALTER trigger doccounts_biu for doccounts
	active before insert or update position 0
	AS
	begin
		if ( (new.dc_locked = 1) and (old.dc_locked = new.dc_locked) ) then
			exception ex_deadlock;
	end
/*SQLStop>*/

/*SQLStart>2444*/
	drop trigger set_dayfinish_id;
/*SQLStop>*/

/*SQLStart>2446*/
	CREATE OR ALTER trigger set_dayfinish_id for dayfinish
	active before insert position 0
	AS
	declare variable num smallint;
	BEGIN
	  NEW.DF_Date = CURRENT_TIMESTAMP;

	  select count(*) from DayFinish
	  where (DF_OperatorID = New.DF_OperatorID) and 
			(AStripTime(DF_Date) = AStripTime(NEW.DF_Date))
	  into :num;

	  if (num is null) then
		num = 1;
	  else
		num = num + 1;

	  NEW.DF_NUM = :num;
	end;
/*SQLStop>*/

/*SQLStart>2448*/
	CREATE OR ALTER trigger set_lp_dayvalue for lixvpercent
	active before update position 0
	as
	begin
	  new.LP_DVALUE = new.LP_Value/36000;
	end
/*SQLStop>*/

/*SQLStart>2450*/
	CREATE OR ALTER trigger set_lp_dtstop for lixvpercent
	active before insert position 0
	as
	begin
	  update lixvpercent set LP_DTStop=New.LP_DTStart-1
	  where LP_Id = New.LP_ID-1;
	  new.LP_DVALUE = new.LP_Value/36000;
	end
/*SQLStop>*/

/*SQLStart>2452*/
	update system_strings set sys_str = '6.7.192.1' where sys_id = 1401;  /*BackOffice*/
/*SQLStop*/