/*ALIAS>l_data*/

/*SQLStart>611*/
CREATE GENERATOR TAXI_ID_GEN;
/*SQLStop*/

/*SQLStart>612*/
SET GENERATOR TAXI_ID_GEN TO 0;
/*SQLStop*/

/*SQLStart>613*/
CREATE TABLE TAXI (
    TAXI_ID INTEGER NOT NULL PRIMARY KEY,
    TAXI_TYPE INTEGER,
    TAXI_DEALER INTEGER,
    TAXI_CAR INTEGER,
    TAXI_REGNUM VARCHAR(100),
    TAXI_CARTERNUM VARCHAR(100),
    TAXI_DATESTART DATE,
    TAXI_DATESTOP DATE,
    TAXI_BREAK DATE,
    TAXI_BREAKCOMMENT VARCHAR(240),
    TAXI_COMMENT VARCHAR(240),
    TAXI_ERASED BOOLEAN DEFAULT 0
);
/*SQLStop*/

/*SQLStart>614*/
GRANT ALL ON TAXI TO PUBLIC;
/*SQLStop*/

/*SQLStart>615*/
CREATE GENERATOR CAR_ID_GEN;
/*SQLStop*/

/*SQLStart>616*/
SET GENERATOR CAR_ID_GEN TO 0;
/*SQLStop*/

/*SQLStart>617*/
CREATE TABLE CARS (
    CAR_ID INTEGER NOT NULL PRIMARY KEY,
    CAR_MARK INTEGER,
    CAR_MODEL INTEGER,
    CAR_CITY INTEGER,
    CAR_OWNER INTEGER,
    CAR_REGNUM VARCHAR(50),
    CAR_YEAR INTEGER,
    CAR_COMMENT VARCHAR(240));
/*SQLStop*/

/*SQLStart>618*/
GRANT ALL ON CARS TO PUBLIC;
/*SQLStop*/

/*SQLStart>619*/
CREATE TABLE CARMARK (
    CARMARK_ID INTEGER NOT NULL PRIMARY KEY,
    CARMARK_TEXT VARCHAR(240),
    CARMARK_NUMKIND INTEGER);
/*SQLStop*/

/*SQLStart>620*/
GRANT ALL ON CARMARK TO PUBLIC;
/*SQLStop*/

/*SQLStart>621*/
CREATE TABLE CARMODEL (
    CARMODEL_ID INTEGER NOT NULL PRIMARY KEY,
    CARMODEL_CARMARKID INTEGER,
    CARMODEL_TEXT VARCHAR(240),
    CARMODEL_NUMKIND INTEGER);
/*SQLStop*/

/*SQLStart>622*/
GRANT ALL ON CARMODEL TO PUBLIC;
/*SQLStop*/

/*SQLStart>623*/
CREATE TABLE CARDRIVERS (
    CARDRIVER_ID INTEGER NOT NULL,
    CARDRIVER_NUM INTEGER NOT NULL,
    CARDRIVER_PERSON INTEGER NOT NULL,
    CARDRIVER_COMMENT VARCHAR(240),
    CARDRIVER_ACTIVE BOOLEAN DEFAULT 1 NOT NULL,
    CARDRIVER_ERASED BOOLEAN DEFAULT 0 NOT NULL);
/*SQLStop*/

/*SQLStart>624*/
GRANT ALL ON CARDRIVERS TO PUBLIC;
/*SQLStop*/

/*SQLStart>625*/
alter table CARDRIVERS
add constraint PK_CARDRIVERS
primary key (CARDRIVER_ID,CARDRIVER_NUM);
/*SQLStop*/

/*SQLStart>626*/
CREATE INDEX PAYTOID ON PAYMENT (P_TOID);
/*SQLStop*/

/*SQLStart>627*/
CREATE INDEX PAYTOIDADV ON PAYMENT (P_ID,P_TYPE,P_TOID);
/*SQLStop*/

/*SQLStart>628*/
CREATE TABLE TAXITYPE (
    TAXITYPE_ID INTEGER NOT NULL PRIMARY KEY,
    TAXITYPE_TEXT VARCHAR(240),
    TAXITYPE_NUMKIND INTEGER);
/*SQLStop*/

/*SQLStart>629*/
GRANT ALL ON TAXITYPE TO PUBLIC;
/*SQLStop*/

/*SQLStart>630*/
CREATE PROCEDURE AGetLastPay (
    AID integer,
    AType integer)
returns (
    OutID integer)
as
begin
  select max(payinner.p_num) from payment payinner  where (payinner.p_id=:aid) and
   (payinner.p_type=:atype) and (payinner.p_flags like "__0%")
   and (payinner.p_fnum is not null)
  into :outid;
  suspend;
end
/*SQLStop*/

/*SQLStart>631*/
delete from system_strings where SYS_ID = 0;
/*SQLStop*/

/*SQLStart>632*/
insert into system_strings (SYS_ID,SYS_STR) values (0,'0003');
/*SQLStop*/