/*ALIAS>prop_db*/

/*SQLStart>2380*/
CREATE GENERATOR POS_ID_GEN;
/*SQLStop*/

/*SQLStart>2385*/
CREATE TABLE POSTRANSACTIONS (
    POS_ID                        INTEGER NOT NULL,
    POS_FUNCTIONN                 VARCHAR(1),
    POS_TERMINALID                VARCHAR(255),
    POS_BOOKKEEPINGPERIOD         VARCHAR(255),
    POS_AUTHORIZATIONCODE         VARCHAR(255),
    POS_RETRIEVALREFERENCENUMBER  VARCHAR(255),
    POS_AMOUNT                    NUMERIC(15,2),
    POS_CASHBACK                  NUMERIC(15,2),
    POS_LOYALTYPREMIUM            NUMERIC(15,2),
    POS_CARDHOLDERID              VARCHAR(255),
    POS_DATEADDED                 DATE
);
/*SQLStop*/

/*SQLStart>2390*/
ALTER TABLE POSTRANSACTIONS ADD CONSTRAINT PK_POSTRANSACTIONS PRIMARY KEY (POS_ID);
/*SQLStop*/

/*SQLStart>2395*/
CREATE OR ALTER TRIGGER POSTRANSACTIONS_BI0 FOR POSTRANSACTIONS
ACTIVE BEFORE INSERT POSITION 0
AS
begin
    if ((new.pos_id is null) or (new.pos_id = 0)) then
  begin
      NEW.pos_id = GEN_ID(pos_id_gen, 1);
  end
end
/*SQLStop*/

/*SQLStart>2400*/
GRANT ALL ON POSTRANSACTIONS TO PUBLIC;
/*SQLStop*/

/*SQLStart>2405*/
GRANT ALL ON POSTRANSACTIONS TO SYSCREAT WITH GRANT OPTION;
/*SQLStop*/

/*SQLStart>2410*/
ALTER TABLE INVOICES ADD IN_POSID INTEGER;
/*SQLStop*/

/*SQLStart>2415*/
ALTER TABLE INVOICES ADD IN_POSRRN VARCHAR(15);
/*SQLStop*/

/*SQLStart>2420*/
update system_strings set sys_str = '6.7.190.1' where sys_id = 1401;  /*BackOffice*/
/*SQLStop*/