/*ALIAS>prop_db*/

/*SQLStart>1880*/
CREATE TABLE INDETAILFAKE (
    IDF_ID           INTEGER NOT NULL,
    IDF_ARTICLE      VARCHAR(250),
    IDF_QUANTITY     INTEGER,
    IDF_SUM          ACS_DOUBLE /* ACS_DOUBLE = NUMERIC(15,3) */,
    IDF_DDS          ACS_INTEGER /* ACS_INTEGER = INTEGER default 0 NOT NULL */,
    IDF_INID         INTEGER,
    IDF_SINGLEPRICE  REAL3 /* REAL3 = NUMERIC(15,2) */,
    IDF_ACTIVE       SMALLINT,
    IDF_MEASURE      VARCHAR(50)
);
/*SQLStop*/

/*SQLStart>1882*/
ALTER TABLE INDETAILFAKE ADD CONSTRAINT PK_INDETAILFAKE PRIMARY KEY (IDF_ID);
/*SQLStop*/

/*SQLStart>1884*/
CREATE GENERATOR IN_IDF_GEN;
/*SQLStop*/

/*SQLStart>1886*/
SET GENERATOR IN_IDF_GEN TO 0;
/*SQLStop*/

/*SQLStart>1888*/
CREATE OR ALTER TRIGGER SET_IDF_ID FOR INDETAILFAKE
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  if ((NEW.IDF_ID is NULL) OR (NEW.IDF_ID < 1)) then
  begin
    NEW.IDF_ID=GEN_ID(in_idf_gen,1);
  end
end
/*SQLStop*/

/*SQLStart>1890*/
GRANT ALL ON INDETAILFAKE TO PUBLIC;
/*SQLStop*/

/*SQLStart>1892*/
UPDATE payment
SET payment.p_dds = (payment.p_val * 0.2)	-- 0.2 za DDS
WHERE( payment.p_id IN
    (
    SELECT payment.p_id
    FROM (payment
    INNER JOIN invoices
    ON  (payment.p_val = invoices.in_payclearsum
        AND payment.p_id = invoices.in_payid)
    ) INNER JOIN documents
    ON documents.doc_id = payment.p_id
    WHERE invoices.in_payclearsum < 0
    AND invoices.in_paydds < 0    -- za KI
    AND payment.p_dds = 0
    AND (EXTRACT(YEAR FROM payment.p_data) = EXTRACT(YEAR FROM invoices.in_paydate))
    AND (EXTRACT(MONTH FROM payment.p_data) = EXTRACT(MONTH FROM invoices.in_paydate))
    AND (EXTRACT(DAY FROM payment.p_data) = EXTRACT(DAY FROM invoices.in_paydate))
    AND documents.doc_type IN (1002, 1004, 1400, -1002, -1004, -1400, 9002, 9004, 9400, -9002, -9004, -9400)
    ))
AND payment.p_val < 0
AND payment.p_dds = 0
AND payment.p_paytype <> 2;
/*SQLStop>1892*/

/*ManyStart>1895*/
update system_strings set sys_str = '6.7.153.3' where sys_id = 1402;  /*Imot*/
update system_strings set sys_str = '2.1.21.1' where sys_id = 1401;      /*Kasa*/
update system_strings set sys_str = '2.1.3.1' where sys_id = 1403;      /*Incomes*/
update system_strings set sys_str = '6.1.14.2' where sys_id = 1404;      /*Rents*/
/*ManyStop>1895*/